require "thread"
require "timeout"

def calc_fib(n)
  if n == 0
    0
  elsif n == 1
    1
  else
    calc_fib(n-1) + calc_fib(n-2)
  end
end

lock = Mutex.new

threads = 20.times.collect do
  Thread.new do
    20.times do
      begin
        Timeout.timeout(0.25) do
          lock.synchronize{ calc_fib(1000) }
        end
      rescue ThreadError => e
        puts "#{e.class}: #{e.message}:\n" + e.backtrace.join("\n") + "\n\n"
      rescue Timeout::Error => e
        #puts e.class
        nil
      end
    end
  end
end

threads.each{ |t| t.join }