require "openssl"
require "socket"

# this test just ping-pongs 1M worth of zeros for 500 clients
nr = 500
bytes = 1024 * 1024

Thread.abort_on_exception = true
DHParam = OpenSSL::PKey::DH.new(128)
host = "127.0.0.1"
ctx = OpenSSL::SSL::SSLContext.new()
ctx.ciphers = "ADH"
ctx.tmp_dh_callback = proc { DHParam }
tcps = TCPServer.new(host, 0)
port = tcps.addr[1]
ssls = OpenSSL::SSL::SSLServer.new(tcps, ctx)
srv_clients = []

srv_thread = Thread.new do
  nr.times do
    client = ssls.accept
    if IO.copy_stream("/dev/zero", client, bytes) ==
       IO.copy_stream(client, "/dev/null", bytes)
      srv_clients << client
    end
  end
end

conn_clients = []
ctx = OpenSSL::SSL::SSLContext.new()
ctx.ciphers = "ADH"
nr.times do
  s = TCPSocket.new(host, port)
  ssl = OpenSSL::SSL::SSLSocket.new(s, ctx)
  ssl.connect
  ssl.sync_close = true
  if IO.copy_stream(ssl, "/dev/null", bytes) ==
     IO.copy_stream("/dev/zero", ssl, bytes)
    conn_clients << ssl
  end
end

srv_thread.join
puts "conn_clients: #{conn_clients.size}"
puts "srv_clients: #{srv_clients.size}"

puts File.readlines("/proc/#$$/status").grep(/VmRSS/)[0]
