require "socket"
require "tempfile"
require "io/nonblock"
a, b = UNIXSocket.pair
b.nonblock = true
Tempfile.open("copy_stream_test") do |tmp|
  IO.copy_stream("/dev/zero", tmp.to_io, 1024 * 1024 * 30)
  tmp.flush
  tmp.rewind

  # maxes out CPU because we select() on tmp.fileno which always
  # returns true, and sendfile() always hits EAGAIN because we
  # only select() b.fileno for readability (not writability)
  nr = IO.copy_stream(tmp.to_io, b)
end
