require "openssl"
require "socket"
Thread.abort_on_exception = true
nr = 500

host = "127.0.0.1"
server = TCPServer.new(host, 0)
accepted = []
connected = []
port = server.addr[1]
server_ctx = OpenSSL::SSL::SSLContext.new
server_ctx.ciphers = "ALL"
client_ctx = OpenSSL::SSL::SSLContext.new
client_ctx.ciphers = "ALL"

server_ctx.options = client_ctx.options = case ENV["NOCOMP"].to_i
when 0
  puts "Compression enabled"
  OpenSSL::SSL::OP_ALL
else
  puts "Compression disabled"
  OpenSSL::SSL::OP_ALL | OpenSSL::SSL::OP_NO_COMPRESSION
end

server = OpenSSL::SSL::SSLServer.new(server, server_ctx)
server.start_immediately = true

wbuf = "HI"

thr = Thread.new do
  nr.times do
    client = server.accept
    client.write(wbuf)
    accepted << client
  end
end

nr.times do
  sock = TCPSocket.new(host, port)
  c = OpenSSL::SSL::SSLSocket.new(sock, client_ctx)
  c.connect
  c.read(2)
  connected << c
end
thr.join

begin
  puts File.readlines("/proc/#$$/status").grep(/VmRSS:/) # for Linux
rescue
  trap(:INT) { exit }
  puts "Check memory usage of pid=#$$, Ctrl-C when done"
  sleep
end
