#!/usr/bin/env ruby

class ThreadPool
    attr_accessor :size, :threads, :jobs

    def initialize(size)
        @size    = size
        @jobs    = Queue.new
        @threads = create_threads
    end

    def create_threads
        @size.times.map do |i|
            Thread.start do
                Thread.current[:id] = i

                catch(:thread_quit) do
                    loop do
                        job, args = @jobs.pop
                        job.call *args
                    end
                end
            end
        end
    end

    def join
        threads.each &:join
    end

    def shutdown
        size.times do
            add { throw :thread_quit }
        end

        threads.map &:join
    end

    def add(*args, &job)
        jobs << [job, args]
    end

    def queue_size;
        jobs.size
    end
end


loop do
    pool = ThreadPool.new 2

    128.times do |i|
        pool.add(i) do |i|
            sleep 0.001
        end
    end

    pool.join
end
