require 'yaml'
require 'ostruct'
require 'ap'

module Arachni
    class Issue
        def method_missing( sym, val )
            if sym.to_s.end_with? '='
                instance_variable_set( "@#{k.to_s}".to_sym, v )
            else
                instance_variable_get( "@#{k.to_s}".to_sym )
            end
        end
    end
end

m = Marshal.load( IO.read( 'dump.marshal' ) )
y = YAML.load( IO.read( 'dump.yaml' ) )

puts 'Proper object -- YAML'
ap y['instances'].first

puts
puts 'Corrupted object - Marshal'
ap m['instances'].first

puts
puts 'Not reproduced -- YAML -> Marshal'
ap Marshal.load( Marshal.dump( YAML.load( IO.read( 'dump.yaml' ) ) ) )['instances'].first
