class Fail
  def render(scope = Object.new)
    compiled_method.bind(scope).call
  end

  def compiled_method
    @compiled_method ||= compile_template_method
  end

  def source
    "Hello world".inspect
  end

  def compile_template_method
    method_name = "__tilt_#{Thread.current.object_id.abs}"
    Object.class_eval("def #{method_name}; #{source} end")
    unbind_compiled_method(method_name)
  end

  def unbind_compiled_method(method_name)
    method = Object.instance_method(method_name)
    Object.class_eval { remove_method(method_name) }
    method
  end
end

loop do
  Fail.new.render
end

