require 'test/unit'
require 'tempfile'

class TestUtf16 < Test::Unit::TestCase
  def setup
    @tempfile = Tempfile.new('utf16test')
    @tempname = @tempfile.path
    @tempfile.close!
    File.open(@tempname, 'wb:utf-16') do |f|
      f.write <<EOF
This is not a love song.
This is not a love song.
EOF
    end
  end
  
  def teardown
    File.delete(@tempname)
  end
  
  def test_hello
    file = File.open(@tempname, 'rb:UTF-16LE')
    begin
      file.each_line do |line|
        assert_equal 'This is not a love song.', line.rstrip.encode('utf-8')
      end  
    ensure
      file.close
    end
  end
end
