require 'test/unit'
require 'tempfile'

class TestUtf16 < Test::Unit::TestCase
  def setup
    p 'setup'
    @tempfile = Tempfile.new('utf16test')
    @tempname = @tempfile.path
    @tempfile.close!
    File.open(@tempname, 'wb:utf-16') do |f|
      f.write <<EOF
This is not a love song.
This is not a love song.
EOF
    end
  end
  
  def teardown
    p 'teardown'
    File.delete(@tempname)
  end
  
  def test_hello
    no_exception = true
    File.open(@tempname, 'rb:utf-16').each_line do |line|
      begin
        assert_equals 'This is not a love song.', line.rstrip
      rescue Encoding::CompatibilityError => e
        no_exception = false
      end  
    end.close
    assert no_exception
  end
end
