require 'fiddle'
# Initialize platform-dependent constants
# a) libraries and DLL versions
if RUBY_VERSION == "1.9.3"
	require 'dl' 
	rubyver = '191'
elsif RUBY_VERSION == "2.0.0"
	DL = Fiddle
	rubyver = '200'
else
	
end
# b) Ruby runtime library name
libname = \
case RUBY_PLATFORM
	when 'x64-mingw32' 
		"x64-msvcrt-ruby#{rubyver}.dll"
	when 'i386-mingw32' 
		"msvcrt-ruby#{rubyver}.dll"
	else
		raise "Unknown platform #{RUBY_PLATFORM}"
end
# Generate rb_iseq_load DLL function wrapper
librb = DL.dlopen(libname)
rb_iseq_load = Fiddle::Function.new(
	librb['rb_iseq_load'],
	[Fiddle::TYPE_VOIDP,
	Fiddle::TYPE_VOIDP,
	Fiddle::TYPE_VOIDP],
	Fiddle::TYPE_VOIDP
	)
iseq_load = Proc.new do |data|
	rb_iseq_load.call(
		DL.dlwrap(data), 
		DL.dlwrap(nil), 
		DL.dlwrap(nil)).to_value
end
# Test
data = RubyVM::InstructionSequence.compile_file('hello.rb').to_a
iseq = iseq_load.(data)
iseq.eval