
module RequireRelativeChecker
  CHECKED_FEATURES = {}
  def require feature
    caller_loc = caller_locations(1)[0]
    caller_dir = File.dirname(caller_loc.path)
    if $LOAD_PATH.include? caller_dir
      caller_dir = File.join(caller_dir, File.basename(caller_loc.path, '.rb'))
    end
    old_features = $LOADED_FEATURES.dup
    super
    new_features = $LOADED_FEATURES.dup
    (new_features - old_features).each{|new_feature|
      if new_feature.start_with?(caller_dir) && !CHECKED_FEATURES.include?(new_feature)
        CHECKED_FEATURES[new_feature] = true
        # p [:begin_with, caller_dir, new_feature]
        STDERR.puts "#{caller_loc.path}:#{caller_loc.lineno}: WARNING: Use require_relative() to require #{new_feature}."
      end
    }
  end
end

class Object
  prepend RequireRelativeChecker
end
