#!/usr/bin/env ruby

puts "Run this in another terminal:"
puts ""
puts "  sudo ./trace-gc-standalone.sh #{$$}"
puts ""
puts "... wait for the 'Ready!' message, switch back here and press enter to start."

GC::Profiler.enable
$stdin.gets

GC::Profiler.clear
time_before = GC::Profiler.total_time

# Generate some GC stress...
300.times do
  symbols = (1..1000).to_a.map { |i| "s#{i}".to_sym }.shuffle
  10.times { symbols.sort }
end

time_after = GC::Profiler.total_time
records = GC::Profiler.raw_data

total_gc_time = time_after - time_before

mark_times  = records.map { |r| r[:GC_MARK_TIME] }.compact
sweep_times = records.map { |r| r[:GC_SWEEP_TIME] }.compact
total_mark_time = mark_times.inject(:+)
total_sweep_time = sweep_times.inject(:+)

puts "Total mark time:  %.1f ms" % [total_mark_time * 1000]
puts "Total sweep time: %.1f ms" % [total_sweep_time * 1000]
puts "Total GC time:    %.1f ms" % [total_gc_time * 1000]
