require 'openssl'
OpenSSL::Engine.load
gost_engine = OpenSSL::Engine.by_id('gost')
gost_engine.set_default(0xFFFF)

crt = OpenSSL::X509::Certificate.new(File.read('gost_r_34_10_2001_certificate.pem'))
privkey = OpenSSL::PKey.read(File.read('gost_r_34_10_2001_private_key.pem'))

data = 'Some message'

dgst94  = gost_engine.digest('md_gost94')
signature = privkey.sign(dgst94, data)

puts crt.public_key.verify(dgst94, signature, data) # Should be true
puts crt.public_key.verify(dgst94, signature, data.sub('S', 'Not s')) # Should be false
