require 'benchmark'

n = 100000
Benchmark.bm do |x|
  x.report('Date::valid_date?:') do
    n.times do
      Date.valid_date?(2001,2,3)
    end
  end
  x.report('Date::new:') do
    n.times do
      Date.new(2001,2,3)
    end
  end
  d = Date.new(2001,2,3)
  x.report('Date#to_s:') do
    n.times do
      d.to_s
    end
  end
  x.report('Date#strftime:') do
    n.times do
      d.strftime('%F%T%N%z %Y-%j')
    end
  end
  a = []
  n.times do
    a << Date.new(rand(2000), rand(12) + 1, rand(28) + 1)
  end
  x.report('[Date]#sort:') do
    a.sort
  end

  x.report('DateTime::new:') do
    n.times do
      DateTime.new(2001,2,3, 4,5,6)
    end
  end
  dt = DateTime.new(2001,2,3, 4,5,6)
  x.report('DateTime#to_s:') do
    n.times do
      dt.to_s
    end
  end
  x.report('DateTime#strftime:') do
    n.times do
      dt.strftime('%F%T%N%z %Y-%j')
    end
  end
  a = []
  n.times do
    a << DateTime.new(rand(2000), rand(12) + 1, rand(28) + 1, rand(24), rand(60), rand(60))
  end
  x.report('[DateTime]#sort:') do
    a.sort
  end

=begin
  x.report('Time::new:') do
    n.times do
      Time.new(2001,2,3, 4,5,6)
    end
  end
  t = Time.new(2001,2,3, 4,5,6)
  x.report('Time#to_s:') do
    n.times do
      t.to_s
    end
  end
  x.report('Time#strftime:') do
    n.times do
      t.strftime('%F%T%N%z %Y-%j')
    end
  end
  a = []
  n.times do
    a << Time.new(rand(2000), rand(12) + 1, rand(28) + 1, rand(24), rand(60), rand(60))
  end
  x.report('[Time]#sort:') do
    a.sort
  end
=end
end
