require 'benchmark'

n = 100000
Benchmark.bm do |x|
  x.report('Date::valid_date?:') do
    n.times do
      Date.valid_date?(2001,2,3,Date::GREGORIAN)
    end
  end
  x.report('Date::new:') do
    n.times do
      Date.new(2001,2,3,Date::GREGORIAN)
    end
  end
  d = Date.new(2001,2,3,Date::GREGORIAN)
  x.report('Date#to_s:') do
    n.times do
      d.to_s
    end
  end
  x.report('Date#+:') do
    n.times do
      d + 10
    end
  end
  x.report('Date#-:') do
    n.times do
      d - 10
    end
  end
  a = []
  n.times do
    a << Date.new(rand(2000), rand(12) + 1, rand(28) + 1, Date::GREGORIAN)
  end
  x.report('[Date]#sort:') do
    a.sort
  end
end
