#!/usr/bin/ruby

puts "$SAFE = #{$SAFE}", "ARGV[0] = #{ARGV[0]}", ""

class MyFile
  def load(arg)
    puts "filename: #{arg}"
    puts "Old load, arg.tainted? == #{arg.tainted?}"
    begin
      File.stat(arg)
    rescue Exception => e
      puts "exception: #{e}, filename: #{arg}"
    end
  end
end


class MyFile
  alias :oldload :load
  def load(arg)
    puts "New load, arg.tainted? == #{arg.tainted?}"
    arg = arg.dup.untaint if arg.kind_of? String
    puts "          arg.tainted? == #{arg.tainted?}"
    oldload(arg)
    puts
  end
end

mf = MyFile.new

Dir.glob('test*.txt').sort.each do |fname|
  if ARGV[0] == 't' or ARGV[0] == 'b' # `Tainted' or `Both'
    puts "fname w/o untaint "
    mf.load fname
  end
  if ARGV[0] == 'u' or ARGV[0] == 'b' # `Untainted' or `Both'
    puts "fname with untaint "
    mf.load fname.untaint
  end
end
