require 'test/unit'

class TestLambdaRelaxedParameters < Test::Unit::TestCase
  def yield_block
    yield
  end

  def yield_1(arg)
    yield arg
  end

  def test_yield_relaxed_lambda_args_none
    assert_equal(42, yield_1([], &lambda{42}))
  end

  def test_yield_lambda_args_none
    assert_equal(42, yield_block(&lambda{42}))
  end

  def test_yield_relaxed_lambda_args_plain
    assert_equal([1,2,3], yield_1([1,2,3], &lambda{|a,b,c| [a,b,c]}))
  end

  def test_yield_lambda_args_plain
    exception = assert_raise(ArgumentError) { yield_1([1,2,3], &lambda{|a,b,c,d|}) }
    assert_equal("wrong number of arguments (1 for 4)", exception.message)

    exception = assert_raise(ArgumentError) { yield_1([1,2,3], &lambda{|a,b|}) }
    assert_equal("wrong number of arguments (1 for 2)", exception.message)
  end

  def test_yield_lambda_args_plain_single
    assert_equal([1], yield_1([1], &lambda{|a| a}))
  end

  def test_yield_relaxed_lambda_args_rest
    assert_equal([1,2,[3]], yield_1([1,2,3], &lambda{|a,b,*c| [a,b,c]}))
  end

  def test_yield_lambda_args_rest
    assert_equal([[1,2], []], yield_1([1,2], &lambda{|a,*b| [a,b]}))
    exception = assert_raise(ArgumentError) { yield_1([1,2], &lambda{|a,b,c,*d| }) }
    assert_equal("wrong number of arguments (1 for 3+)", exception.message)
  end

  def test_yield_lambda_args_rest_single
    assert_equal(nil,       yield_1([1,2,3], &lambda{|*| }))
    assert_equal([[1,2,3]], yield_1([1,2,3], &lambda{|*a| a}))
  end

  def test_yield_relaxed_lambda_args_pos_rest_post
    assert_equal([1,[],2],  yield_1([1,2],   &lambda{|a,*b,c| [a,b,c]}))
    assert_equal([1,[2],3], yield_1([1,2,3], &lambda{|a,*b,c| [a,b,c]}))
  end

  def test_yield_lambda_args_pos_rest_post
    exception = assert_raise(ArgumentError) { yield_1([1], &lambda{|a,*b,c| [a,b,c]}) }
    assert_equal("wrong number of arguments (1 for 2+)", exception.message)
  end

  def test_yield_relaxed_lambda_args_rest_post
    assert_equal([[],1,2],  yield_1([1,2],  &lambda{|*a,b,c| [a,b,c]}))
    assert_equal([[1],2,3], yield_1([1,2,3],&lambda{|*a,b,c| [a,b,c]}))
  end

  def test_yield_lambda_args_rest_post
    assert_equal([[],[1,2,3]],  yield_1([1,2,3],  &lambda{|*a,b| [a,b]}))

    exception = assert_raise(ArgumentError) { yield_1([1,2], &lambda{|*a,b,c,d|}) }
    assert_equal("wrong number of arguments (1 for 3+)", exception.message)
  end

  def test_yield_relaxed_lambda_args_pos_opt
    assert_equal([1,2,:c], yield_1([1,2],   &lambda{|a,b,c=:c| [a,b,c]}))
    assert_equal([1,2,3],  yield_1([1,2,3], &lambda{|a,b,c=:c| [a,b,c]}))
  end

  def test_yield_lambda_args_pos_opt
    assert_equal([[],:b], yield_1([], &lambda{|a,b=:b| [a,b]}))

    exception = assert_raise(ArgumentError) { yield_1([1,2,3,4], &lambda{|a,b,c=:c|}) }
    assert_equal("wrong number of arguments (1 for 2..3)", exception.message)

    exception = assert_raise(ArgumentError) { yield_1([1,2], &lambda{|a,b,c,d=:d|}) }
    assert_equal("wrong number of arguments (1 for 3..4)", exception.message)
  end

  def test_yield_lambda_args_opt
    assert_equal([[1,2,3], :b, :c], yield_1([1,2,3], &lambda{|a=:a,b=:b,c=:c| [a,b,c]}))
  end

  def test_yield_lambda_args_opt_single
    assert_equal([1], yield_1([1], &lambda{|a=:a| a}))
  end

  def test_yield_relaxed_lambda_args_pos_opt_post
    assert_equal([1,:b,2], yield_1([1,2],   &lambda{|a,b=:b,c| [a,b,c]}))
    assert_equal([1,2,3],  yield_1([1,2,3], &lambda{|a,b=:b,c| [a,b,c]}))
  end

  def test_yield_relaxed_lambda_args_opt_post
    assert_equal([:a,1,2], yield_1([1,2],   &lambda{|a=:a,b,c| [a,b,c]}))
    assert_equal([1,2,3],  yield_1([1,2,3], &lambda{|a=:a,b,c| [a,b,c]}))
  end

  def test_yield_lambda_args_opt_post
    assert_equal([:a,[]], yield_1([], &lambda{|a=:a,b| [a,b]}))

    exception = assert_raise(ArgumentError) { yield_1([1,2,3,4], &lambda{|a=:a,b,c|}) }
    assert_equal("wrong number of arguments (1 for 2..3)", exception.message)

    exception = assert_raise(ArgumentError) { yield_1([1,2,3], &lambda{|a=:a,b,c,d,e|}) }
    assert_equal("wrong number of arguments (1 for 4..5)", exception.message)
  end

  def test_yield_relaxed_lambda_args_pos_opt_rest
    assert_equal([1,2,:c,[]], yield_1([1,2],     &lambda{|a,b,c=:c,*d|[a,b,c,d]}))
    assert_equal([1,2,3,[]],  yield_1([1,2,3],   &lambda{|a,b,c=:c,*d|[a,b,c,d]}))
    assert_equal([1,2,3,[4]], yield_1([1,2,3,4], &lambda{|a,b,c=:c,*d|[a,b,c,d]}))
  end

  def test_yield_lambda_args_pos_opt_rest
    assert_equal([[1],:b,[]],     yield_1([1],     &lambda{|a,b=:b,*c|[a,b,c]}))
    assert_equal([[1,2],:b,[]],   yield_1([1,2],   &lambda{|a,b=:b,*c|[a,b,c]}))
    assert_equal([[1,2,3],:b,[]], yield_1([1,2,3], &lambda{|a,b=:b,*c|[a,b,c]}))

    exception = assert_raise(ArgumentError) { yield_1([1,2], &lambda{|a,b,c,d=:d,*e|}) }
    assert_equal("wrong number of arguments (1 for 3+)", exception.message)
  end

  def test_yield_lambda_args_opt_rest
    assert_equal([[1,2,3], []], yield_1([1,2,3], &lambda{|a=:a,*b|[a,b]}))
    assert_equal([[1,2,3,4], :b, :c, []], yield_1([1,2,3,4], &lambda{|a=:a,b=:b,c=:c,*d|[a,b,c,d]}))
  end

  def test_yield_relaxed_lambda_args_pos_opt_rest_post
    assert_equal([1,:b,[],2], yield_1([1,2],     &lambda{|a,b=:b,*c,d| [a,b,c,d]}))
    assert_equal([1,2,[],3],  yield_1([1,2,3],   &lambda{|a,b=:b,*c,d| [a,b,c,d]}))
    assert_equal([1,2,[3],4], yield_1([1,2,3,4], &lambda{|a,b=:b,*c,d| [a,b,c,d]}))
  end

  def test_yield_relaxed_lambda_args_opt_rest_post
    assert_equal([:a,[],1,2], yield_1([1,2],     &lambda{|a=:a,*b,c,d|[a,b,c,d]}))
    assert_equal([1,[],2,3],  yield_1([1,2,3],   &lambda{|a=:a,*b,c,d|[a,b,c,d]}))
    assert_equal([1,[2],3,4], yield_1([1,2,3,4], &lambda{|a=:a,*b,c,d|[a,b,c,d]}))
  end

  def test_yield_lambda_args_opt_rest_post
    assert_equal([:a,[],[]],      yield_1([],      &lambda{|a=:a,*b,c|[a,b,c]}))
    assert_equal([:a,[],[1,2,3]], yield_1([1,2,3], &lambda{|a=:a,*b,c|[a,b,c]}))

    exception = assert_raise(ArgumentError) { yield_1([1], &lambda{|a=:a,*b,c,d| }) }
    assert_equal("wrong number of arguments (1 for 2+)", exception.message)
  end

  def test_yield_relaxed_lambda_args_block
    assert_equal([nil], yield_1([], &lambda{|&a| [a]}))
  end

  def test_yield_relaxed_lambda_args_pos_block
    assert_equal([1,2,NilClass], yield_1([1,2], &lambda{|a,b,&c| [a,b,c.class]}))
  end

  def test_yield_lambda_args_pos_block
    assert_equal([[1,2], NilClass], yield_1([1,2], &lambda{|a,&b| [a,b.class]}))

    exception = assert_raise(ArgumentError) { yield_1([1,2,3], &lambda{|a,b,&c| [a,b,c.class]}) }
    assert_equal("wrong number of arguments (1 for 2)", exception.message)

    exception = assert_raise(ArgumentError) { yield_1([1,2,lambda{}], &lambda{|a,b,&c| [a,b,c.class]}) }
    assert_equal("wrong number of arguments (1 for 2)", exception.message)

    exception = assert_raise(ArgumentError) { yield_1([1,2,proc{}], &lambda{|a,b,&c| [a,b,c.class]}) }
    assert_equal("wrong number of arguments (1 for 2)", exception.message)
  end

  def test_yield_relaxed_lambda_args_ary_post
    assert_equal([1,2,3], yield_1([[1,2],3], &lambda{|(a,b),c| [a,b,c]}))
  end

  def test_yield_relaxed_lambda_args_ary
    assert_equal([1,2,3,4], yield_1([[1,2],[3,4]], &lambda{|(a,b),(c,d)| [a,b,c,d]}))
  end

  def test_yield_relaxed_lambda_args_kwrest
    assert_equal({}, yield_1([], &lambda{|**kw| kw}))
  end

  def test_yield_relaxed_lambda_args_pos_kwrest
    assert_equal([1,2,3, {}], yield_1([1,2,3], &lambda{|a,b,c,**kw| [a,b,c,kw]}))
  end

  def test_yield_relaxed_lambda_args_pos_opt_kwrest
    assert_equal([1,2,:c, {}], yield_1([1,2],   &lambda{|a,b,c=:c,**kw| [a,b,c,kw]}))
    assert_equal([1,2,3, {}],  yield_1([1,2,3], &lambda{|a,b,c=:c,**kw| [a,b,c,kw]}))
  end

  def test_yield_relaxed_lambda_args_opt_post_kwrest
    assert_equal([:a,1,2,{}],     yield_1([1,2],     &lambda{|a=:a,b,c,**kw| [a,b,c,kw]}))
    assert_equal([1,2,3,{}],      yield_1([1,2,3],   &lambda{|a=:a,b,c,**kw| [a,b,c,kw]}))
    assert_equal([:a,1,{b:2},{}], yield_1([1,{b:2}], &lambda{|a=:a,b,c,**kw| [a,b,c,kw]}))
  end

  # ---------------------------

  def test_yield_lambda_args_ary_single
    assert_equal([1,2],       yield_1([1,2],   &lambda{|(a,b)| [a,b]}))
    assert_equal([[1,2],nil], yield_1([[1,2]], &lambda{|(a,b)| [a,b]}))
  end

  def test_yield_lambda_args_ary_post
    exception = assert_raise(ArgumentError) { yield_1([[1,2]], &lambda{|(a,b),c| }) }
    assert_equal("wrong number of arguments (1 for 2)", exception.message)

    exception = assert_raise(ArgumentError) { yield_1([[1,2],3], &lambda{|(a,b),c,d| }) }
    assert_equal("wrong number of arguments (1 for 3)", exception.message)
  end

  def test_yield_lambda_args_ary_opt
    assert_equal([[1,2], nil,:c], yield_1([[1,2]],  &lambda{|(a,b),c=:c| [a,b,c]}))
    assert_equal([[1,2], 3, :c], yield_1([[1,2],3], &lambda{|(a,b),c=:c| [a,b,c]}))
  end


  def test_yield_lambda_args_opt_kwrest
    assert_equal([[1,2,3],:b,:c,{}],       yield_1([1,2,3],      &lambda{|a=:a,b=:b,c=:c,**kw| [a,b,c,kw]}))
    assert_equal([[1,2,3,{d:4}],:b,:c,{}], yield_1([1,2,3,{d:4}],&lambda{|a=:a,b=:b,c=:c,**kw| [a,b,c,kw]}))
  end

  def test_yield_lambda_args_pos_kwrest
    assert_equal([[], {}],       yield_1([],        &lambda{|a,**kw| [a,kw]}))
    assert_equal([[1], {}],      yield_1([1],       &lambda{|a,**kw| [a,kw]}))
    assert_equal([[1,{a:1}],{}], yield_1([1,{a:1}], &lambda{|a,**kw| [a,kw]}))

    exception = assert_raise(ArgumentError) { yield_1([1,2,3,{d:4}], &lambda{|a,b,c,**kw| [a,b,c,kw]}) }
    assert_equal("wrong number of arguments (1 for 3)", exception.message)
  end

  def test_yield_lambda_args_pos_opt_kwrest
    assert_equal([[1],:b,{}],   yield_1([1],     &lambda{|a,b=:b,**kw| [a,b,kw]}))
    assert_equal([[1,2],:b,{}], yield_1([1,2],   &lambda{|a,b=:b,**kw| [a,b,kw]}))

    exception = assert_raise(ArgumentError) { yield_1([1], &lambda{|a,b,c=:c,**kw| [a,b,c,kw]}) }
    assert_equal("wrong number of arguments (1 for 2..3)", exception.message)

    exception = assert_raise(ArgumentError) { yield_1([1,2,3,4], &lambda{|a,b,c=:c,**kw| [a,b,c,kw]}) }
    assert_equal("wrong number of arguments (1 for 2..3)", exception.message)
  end

  def test_yield_lambda_args_opt_post_kwrest
    assert_equal([:a,[1],{}],       yield_1([1],       &lambda{|a=:a,b,**kw| [a,b,kw]}))
    assert_equal([:a,[1,2],{}],     yield_1([1,2],     &lambda{|a=:a,b,**kw| [a,b,kw]}))
    assert_equal([:a,[1,{b:2}],{}], yield_1([1,{b:2}], &lambda{|a=:a,b,**kw| [a,b,kw]}))

    exception = assert_raise(ArgumentError) { yield_1([1,2,3,4], &lambda{|a=:a,b,c,**kw| [a,b,c,kw]}) }
    assert_equal("wrong number of arguments (1 for 2..3)", exception.message)

    exception = assert_raise(ArgumentError) { yield_1([1,2,3,{}],&lambda{|a=:a,b,c,**kw| [a,b,c,kw]}) }
    assert_equal("wrong number of arguments (1 for 2..3)", exception.message)
  end
end
