module SimpleInspect
  def inspect
    result = if inspected?
               "#<%s (%d) ...>" % [ inspected_key, inspected_count ]
             else
               super
             end
    inspect!
    "\n" + result
  end

  private
  def inspected?
    inspected[inspected_key].nonzero?
  end

  def inspect!
    inspected[inspected_key] += 1
  end

  def inspected_count
    inspected[inspected_key]
  end

  def inspected
    $__inspected__ ||= Hash.new { |h, k| h[k] = 0 }
  end

  def inspected_key
    "%s:0x%014x" % [ self.class, "0x%014x" % (object_id * 2) ]
  end
end

class Object
  include SimpleInspect
end

class Entity
end
class Indect
end
class Koppler
end
class Occupancy
end
class Control
end
class ScheduleEntry
end
class SQLiteStorage
end
class UBox
end
class USpot
end
class UFlag
end
class UFlow
end
class Sign
end
class CounterGroup
end

read = File.read "ruby_object.dump"

File.open('simple-inspect.txt', 'w') { |f| f.puts Marshal.load(read).inspect }
File.open('simple-inspect-stats.txt', 'w') { |f| f.puts $__inspected__.inspect }

Marshal.load(read).each do |id, el|
  puts el.id
  p el
end
