require "coverage"
require "benchmark/ips"

def make_iseq_of_size goal, code
  builder = ->(r) {
    ruby = <<-eoruby
x = 1
#{r.times.map { code }.join "\n" }
    eoruby
    RubyVM::InstructionSequence.compile ruby
  }

  low = 1
  high = builder.(goal).size
  iseq = nil

  while low < high
    mid = low + (high - low) / 2
    iseq = builder.(mid)
    if iseq.size < goal
      low = mid + 1
    else iseq.size > goal
      high = mid - 1
    end
  end

  iseq
end

def make_fast_iseq size
  make_iseq_of_size size, 'x + x'
end

def make_slow_iseq size
  make_iseq_of_size size, 'x = 1'
end

res = Benchmark.ips do |x|
  fast_iseq_100 = make_fast_iseq(100)
  x.report("#{fast_iseq_100.size} fast") { fast_iseq_100.markable_object_count }

  fast_iseq_1000 = make_fast_iseq(1000)
  x.report("#{fast_iseq_1000.size} fast") { fast_iseq_1000.markable_object_count }

  fast_iseq_10000 = make_fast_iseq(10000)
  x.report("#{fast_iseq_10000.size} fast") { fast_iseq_10000.markable_object_count }

  fast_iseq_100000 = make_fast_iseq(100000)
  x.report("#{fast_iseq_100000.size} fast") { fast_iseq_100000.markable_object_count }

  slow_iseq_100 = make_slow_iseq(100)
  x.report("#{slow_iseq_100.size} slow") { slow_iseq_100.markable_object_count }

  slow_iseq_1000 = make_slow_iseq(1000)
  x.report("#{slow_iseq_1000.size} slow") { slow_iseq_1000.markable_object_count }

  slow_iseq_10000 = make_slow_iseq(10000)
  x.report("#{slow_iseq_10000.size} slow") { slow_iseq_10000.markable_object_count }

  slow_iseq_100000 = make_slow_iseq(100000)
  x.report("#{slow_iseq_100000.size} slow") { slow_iseq_100000.markable_object_count }
end

require 'csv'

CSV do |csv|
  csv << ["pointers", "ips"]
  res.entries.each do |entry|
    csv << [entry.label[/^\d+/], entry.ips]
  end
end

__END__

[aaron@TC ruby (eliminate-mark-ary)]$ ./ruby -I ~/git/benchmark-ips/lib x.rb
Warming up --------------------------------------
            107 fast    51.019k i/100ms
            987 fast     6.558k i/100ms
           9987 fast   681.000  i/100ms
          99987 fast    68.000  i/100ms
             98 slow    35.413k i/100ms
            998 slow     3.895k i/100ms
          10004 slow   397.000  i/100ms
          99998 slow    39.000  i/100ms
Calculating -------------------------------------
            107 fast    592.822k (± 4.3%) i/s -      2.959M in   5.002552s
            987 fast     67.417k (± 3.5%) i/s -    341.016k in   5.064936s
           9987 fast      6.671k (± 5.4%) i/s -     33.369k in   5.020232s
          99987 fast    653.789  (± 8.3%) i/s -      3.264k in   5.032978s
             98 slow    378.918k (±10.4%) i/s -      1.912M in   5.113554s
            998 slow     39.021k (± 5.3%) i/s -    194.750k in   5.007117s
          10004 slow      3.894k (± 5.3%) i/s -     19.850k in   5.112539s
          99998 slow    387.217  (± 6.7%) i/s -      1.950k in   5.065411s
pointers,ips
107,592822.1313505468
987,67416.51114832592
9987,6671.08318754785
99987,653.7886910885874
98,378918.2037573504
998,39021.06843464474
10004,3894.3530685987253
99998,387.21668397168526
