﻿# frozen_string_literal: true

# Copyright (C) 2020 Fitmap, Shenzhen, Guangdong, China
# mailto:Fitmap <fitmap@qq.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

require 'test/unit'

require 'clipboard'

# Test Chinese charecters clipboard
class ClipboardTest < Test::Unit::TestCase
  def rnd_chn(num)
    Array.new(num) { (0x4e00 + rand(0x9fa5 - 0x4e00 + 1)).chr(Encoding::UTF_8) }.join
  end

  def test_copy_paste
    999.times do
      text = rnd_chn(rand(256))
      Clipboard.copy(text)
      assert_equal text, Clipboard.paste
      Clipboard.clear
      assert_equal '', Clipboard.paste
    end
  end
end
